/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _SURFACEREMOVECOMMAND_H_
#define _SURFACEREMOVECOMMAND_H_

#include "ICommand.h"

class SurfaceRemoveCommand : public ICommand
{
public:
    /*!
     * \action    This command removes a surface within the GENIVI LayerManagement
     * \frequency Called at end of application or when an application or its window
     *            is shut down.
     * \param[in] sender process id of application that sent this command
     * \param[in] objectID id of surface
     * \ingroup Commands
     */
    SurfaceRemoveCommand(pid_t sender, unsigned int objectID)
    : ICommand(ExecuteSynchronous, sender)
    , m_idToRemove(objectID)
    {}

    /**
     * \brief default destructor
     */
    virtual ~SurfaceRemoveCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement COmmands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionSuccessRedraw: execution successful and screen needs to be redrawn
     * \return ExecutionFailed: execution failed
     * \return ExecutionFailedRedraw: execution unsuccessful and screen needs to be redrawn
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    const unsigned int m_idToRemove;

    // for unit testing
    template<typename idToRemove_type> friend class SurfaceRemoveCommandEqMatcherP;
};

#endif /* _SURFACEREMOVECOMMAND_H_ */
